/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifdef WIN32
#include <afxwin.h>
#endif
#include <stdio.h>             
#include <stdlib.h>             
#include <stddef.h> 
#include <string.h>
#include <signal.h> 
#include "DCSApi.h"
#include "PMApi.h"
#ifndef _WIN32
#define Sleep sleep
#endif

void DCS_ReturnValue_handler(int ret)
{
	switch (ret)
	{
	case DCS_SUCCESS :
		printf("success\n");
		break;
	case DCS_NOT_SUPPORTED :
		printf("request is not supported\n");
		break;
	case DCS_REQUEST_DENIED:
		printf("request is denied\n");
		break;
	case DCS_MODULE_NOTEXIST:
		printf("request module does not exit\n");
		break;
	case DCS_EVENT_NOTEXIST:
		printf("request event does not exit\n");
		break;
	case DCS_FUNC_NOTEXIST:
		printf("request function does not exit\n");
		break;
	case DCS_FAIL_OPERATION:
		printf("operation failed\n");
		break;
	case DCS_CONNECTION_ABORT:
		printf("connection abort\n");
	default:
		break;
	}
}

int main(int argc, char *argv[])
{
	int ret = 0;
	int i=0;
	int use_pm=0;
	int set_cpuspeed=0;
	char c0;

	/*initialize the DCS*/
	ret = DCS_Initialize();

	DCS_ReturnValue_handler( ret);

	int nOldActiveSchemeID;
	ret = DCS_GetActivePwrScheme(&nOldActiveSchemeID);
	DCS_ReturnValue_handler( ret);
	printf("Current Active power scheme ID is %d\n", nOldActiveSchemeID);
	Sleep(1000);

	int nNewSchemeID;
	int nCopyFrom = 0;
	ret = DCS_AddPwrScheme("test1", "test1", nCopyFrom, &nNewSchemeID);
	DCS_ReturnValue_handler( ret);
	printf("Create power scheme ID is %d\n", nNewSchemeID);
	Sleep(1000);

	char bufName[256], bufDesc[256];
	int lenName=256, lenDesc=256;

	ret = DCS_GetPwrSchemeNameDesc(nNewSchemeID, bufName,lenName, bufDesc, lenDesc);
	DCS_ReturnValue_handler( ret);
	printf("Create power scheme name is %s\n", bufName);
	printf("description is %s\n", bufDesc);
	Sleep(1000);

	int val;

	/* set AC variable value.  */
	ret = DCS_SetPwrVariable(nNewSchemeID, TRUE, "CpuSpeed", 100);	
	DCS_ReturnValue_handler( ret);
	Sleep(1000);
	ret = DCS_GetPwrVariable(nNewSchemeID, TRUE, "CpuSpeed", &val);
	DCS_ReturnValue_handler( ret);
	Sleep(1000);
	printf("Created power scheme, CpuSpeed under AC is %d", val);
	
	/* set DC variable value. */
	ret = DCS_SetPwrVariable(nNewSchemeID, FALSE, "CpuSpeed", 100);	
	DCS_ReturnValue_handler( ret);
	Sleep(1000);
	ret = DCS_GetPwrVariable(nNewSchemeID, FALSE, "CpuSpeed", &val);
	DCS_ReturnValue_handler( ret);
	Sleep(1000);
	printf("Created power scheme, CpuSpeed under DC is %d", val);

	/* set active power scheme. */
	ret = DCS_SetActivePwrScheme(nNewSchemeID);
	DCS_ReturnValue_handler( ret);
	Sleep(1000);
	int nCurrentAvtiveSchemeID;
	ret = DCS_GetActivePwrScheme(&nCurrentAvtiveSchemeID);
	DCS_ReturnValue_handler( ret);
	Sleep(1000);
	printf("Current Active power scheme ID is %d\n", nCurrentAvtiveSchemeID);

	/* can't delete active power scheme, so we set active power scheme back to the old active power scheme. */
	ret = DCS_SetActivePwrScheme(nOldActiveSchemeID);
	DCS_ReturnValue_handler( ret);
	Sleep(1000);

	/* delete power scheme. */
	ret = DCS_DeletePwrScheme(nNewSchemeID);
	DCS_ReturnValue_handler( ret);
	printf("Delete Power Scheme %d", nNewSchemeID);

	/*uninitialize the DCS*/
	ret=DCS_Uninitialize();
	DCS_ReturnValue_handler( ret);

	return 0;
}

